package com.qboxus.tictic.activitesfragments.sendgift;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.view.SimpleDraweeView;
import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.Variables;

import java.util.ArrayList;
import java.util.List;


public class StickerAdapter extends RecyclerView.Adapter<StickerAdapter.CustomViewHolder> {

    public Context context;
    List<StickerModel> gif_list = new ArrayList<>();
    private final OnItemClickListener listener;

    public StickerAdapter(Context context, List<StickerModel> gif_list, OnItemClickListener listener) {
        this.context = context;
        this.gif_list = gif_list;
        this.listener = listener;

    }

    @Override
    public CustomViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewtype) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_send_gif_layout, null);
        return new CustomViewHolder(view);
    }

    @Override
    public int getItemCount() {
        return gif_list.size();
    }

    @Override
    public void onBindViewHolder(final CustomViewHolder holder, final int i) {
        StickerModel model = gif_list.get(i);

        if (model.type != null && model.type.equals("gif")) {
            if (model.icon != null && !model.icon.contains(Variables.http)) {
                model.icon = Constants.BASE_URL + model.icon;
            }
            GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(context.getResources());
            GenericDraweeHierarchy hierarchy = builder
                    .setActualImageScaleType(ScalingUtils.ScaleType.CENTER_CROP)
                    .build();

            holder.gif_image.setHierarchy(hierarchy);
            holder.gif_image.setController(Functions.frescoImageLoad(model.icon, holder.gif_image, false));

        } else {
            if (!model.image.contains(Variables.http)) {
                model.image = Constants.BASE_URL + model.image;
            }
            GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(context.getResources());
            GenericDraweeHierarchy hierarchy = builder
                    .setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER)
                    .build();

            holder.gif_image.setHierarchy(hierarchy);
            holder.gif_image.setController(Functions.frescoImageLoad(model.image, holder.gif_image, false));

        }


        holder.name_txt.setText(model.name);
        holder.coins_txt.setText(model.coins);
        if (model.isSelected) {
            holder.sendbtn.setVisibility(View.VISIBLE);
            holder.name_txt.setVisibility(View.GONE);
        } else {
            holder.sendbtn.setVisibility(View.GONE);
            holder.name_txt.setVisibility(View.VISIBLE);
        }

        holder.bind(i, model, listener);
    }


    public interface OnItemClickListener {
        void onItemClick(int position, View view, StickerModel item);
    }

    class CustomViewHolder extends RecyclerView.ViewHolder {
        SimpleDraweeView gif_image;
        TextView name_txt, coins_txt, sendbtn;


        public CustomViewHolder(View view) {
            super(view);
            gif_image = view.findViewById(R.id.gif_image);
            name_txt = view.findViewById(R.id.name_txt);
            coins_txt = view.findViewById(R.id.coin_txt);
            sendbtn = view.findViewById(R.id.sendBtn);
        }

        public void bind(int position, final StickerModel item, final OnItemClickListener listener) {

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.onItemClick(position, v, item);
                }
            });

            sendbtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    listener.onItemClick(position, view, item);
                }
            });

        }

    }

}